using System;
using System.Collections.Generic;
using System.Linq;

public class Resenje
{
    private class Tacka
    {
        public int OriginalniIndeks;
        public double X;
        public double Y;
        public int QIndeks;
    }

    private class Grana
    {
        public int U;
        public int V;
        public double Tezina;
    }

    private static double ManhattanDist(Tacka p1, Tacka p2)
    {
        return Math.Abs(p1.X - p2.X) + Math.Abs(p1.Y - p2.Y);
    }

    private static void ResiTestPrimer()
    {
        string prvaLinija = Console.ReadLine();
        if (string.IsNullOrEmpty(prvaLinija)) return;
        string[] parts = prvaLinija.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);

        int n = int.Parse(parts[0]);
        double epsilon = double.Parse(parts[1], System.Globalization.CultureInfo.InvariantCulture);

        List<Tacka> P = new List<Tacka>(n);
        for (int i = 0; i < n; i++)
        {
            string line = Console.ReadLine();
            string[] coords = line.Split(new char[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
            P.Add(new Tacka
            {
                OriginalniIndeks = i + 1,
                X = double.Parse(coords[0], System.Globalization.CultureInfo.InvariantCulture),
                Y = double.Parse(coords[1], System.Globalization.CultureInfo.InvariantCulture)
            });
        }

        double delta = epsilon / 3.0;
        Dictionary<Tuple<int, int>, Tacka> Q_Map = new Dictionary<Tuple<int, int>, Tacka>();

        foreach (var p in P)
        {
            int c_x = (int)Math.Floor(p.X / delta);
            int c_y = (int)Math.Floor(p.Y / delta);

            c_x = Math.Min(c_x, (int)Math.Floor(1.0 / delta));
            c_y = Math.Min(c_y, (int)Math.Floor(1.0 / delta));
            
            // Ispravka za granice
            if (p.X == 1.0) c_x = (int)Math.Floor(1.0 / delta) - 1;
            if (p.Y == 1.0) c_y = (int)Math.Floor(1.0 / delta) - 1;


            Tuple<int, int> kljuc = new Tuple<int, int>(c_x, c_y);

            if (!Q_Map.ContainsKey(kljuc))
            {
                Q_Map[kljuc] = p;
            }
        }

        List<Tacka> Q = Q_Map.Values.ToList();
        int Q_size = Q.Count;

        if (Q_size == 0)
        {
            Console.WriteLine(0);
            return;
        }

        for (int i = 0; i < Q_size; i++)
        {
            Q[i].QIndeks = i;
        }

        List<int> indeksiQ = Q.Select(p => p.OriginalniIndeks).ToList();
        List<Tuple<int, int>> graneT = new List<Tuple<int, int>>();

        if (Q_size > 1)
        {
            double[] minTezina = new double[Q_size];
            int[] parent = new int[Q_size];
            bool[] uMST = new bool[Q_size];

            for (int i = 0; i < Q_size; i++)
            {
                minTezina[i] = double.MaxValue;
                parent[i] = -1;
            }

            minTezina[0] = 0;
            
            for (int count = 0; count < Q_size; count++)
            {
                int u = -1;
                double min = double.MaxValue;

                for (int i = 0; i < Q_size; i++)
                {
                    if (!uMST[i] && minTezina[i] < min)
                    {
                        min = minTezina[i];
                        u = i;
                    }
                }

                if (u == -1) break; 
                uMST[u] = true;

                if (parent[u] != -1)
                {
                    graneT.Add(new Tuple<int, int>(Q[u].OriginalniIndeks, Q[parent[u]].OriginalniIndeks));
                }

                for (int v = 0; v < Q_size; v++)
                {
                    if (!uMST[v])
                    {
                        double dist = ManhattanDist(Q[u], Q[v]);
                        if (dist < minTezina[v])
                        {
                            minTezina[v] = dist;
                            parent[v] = u;
                        }
                    }
                }
            }
        }

        Console.WriteLine(Q_size);
        Console.WriteLine(string.Join(" ", indeksiQ));
        foreach (var grana in graneT)
        {
            Console.WriteLine($"{grana.Item1} {grana.Item2}");
        }
    }

    public static void Main(string[] args)
    {
        ResiTestPrimer();
    }
}